$(document).ready(function(){
    $('#videoUploadForm').on('submit', function(e){
        e.preventDefault();
        var formData = new FormData(this);

        // প্রোগ্রেস বার দেখানো শুরু করুন
        $('#progressContainer').show();

        $.ajax({
            url: 'upload_video.php',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            xhr: function() {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener('progress', function(evt) {
                    if (evt.lengthComputable) {
                        var percentComplete = Math.round((evt.loaded / evt.total) * 100);
                        var loadedMb = (evt.loaded / (1024*1024)).toFixed(2);
                        var totalMb = (evt.total / (1024*1024)).toFixed(2);
                        
                        $('#progressBar').width(percentComplete + '%');
                        $('#progressBar').html(percentComplete + '%');
                        $('#uploadStatus').html(loadedMb + ' MB / ' + totalMb + ' MB');
                    }
                }, false);
                return xhr;
            },
            success: function(response){
                alert(response); // সার্ভার থেকে আসা বার্তা দেখান
                location.reload(); // পৃষ্ঠা রিলোড করুন
            },
            error: function(){
                alert('ফাইল আপলোডে ত্রুটি হয়েছে!');
                 $('#progressContainer').hide();
            }
        });
    });
});